/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;

import java.util.Vector;

public class Taxonomie {
    public Vector<NuagePondere> themas = new Vector<NuagePondere>();

    public Taxonomie(){

    }

    public void addThematique(NuagePondere thema){
        themas.add(thema);
    }

    public void addThematique(GraphLemmaItem thema){
        NuagePondere nuage = new NuagePondere(thema.getNodeID(), thema.getNodeName());
        Vector<LemmaItem> v = new Vector<LemmaItem>(thema.getLemmas());
        for(int i=0; i<v.size(); i++){
            LemmaItem l = v.elementAt(i);
            if(l.getCountTitle()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountTitle()));
            }
            if(l.getCountDesc()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.ACCES_DESC);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountDesc()));
            }
        }
        themas.add(nuage);
    }

    public void addInThematique(GraphLemmaItem article){
        NuagePondere nuage = findThematique(article.getNodeID());
        if(nuage==null){
            return;
        }
        Vector<LemmaItem> v = new Vector<LemmaItem>(article.getLemmas());
        for(int i=0; i<v.size(); i++){
            LemmaItem l = v.elementAt(i);
            if(l.getCountTitle()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.SPECIALISATION);
                orig.addElement(Operation.ACCES_TITRE);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountTitle()));
            }
            if(l.getCountDesc()>0){
                Vector<Operation> orig = new Vector<Operation>();
                orig.addElement(Operation.SPECIALISATION);
                orig.addElement(Operation.ACCES_DESC);
                nuage.addLemme(new LemmePondere(l.getLemmaName(), orig,
                        l.getLemmaLex(), l.getCountDesc()));
            }
        }
    }

    public NuagePondere[] getThematiques(){
        NuagePondere[] result = new NuagePondere[themas.size()];
        themas.toArray(result);
        return result;
    }

    public void pondereOrigine(Operation origine, double poids){
        for(int i=0; i<themas.size(); i++){
            themas.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void normaliseParTaille(){
        for(int i=0; i<themas.size(); i++){
            themas.elementAt(i).pondereTaille();
        }
    }

    public void pondereCategorie(String categorie, double poids){
        for(int i=0; i<themas.size(); i++){
            themas.elementAt(i).pondereCategorie(categorie, poids);
        }
    }

    public void pondereAllCategories(double poids){
        for(int i=0; i<themas.size(); i++){
            themas.elementAt(i).pondereAllCategories(poids);
        }
    }

    private NuagePondere findThematique(int id){
        NuagePondere result = null;
        for(int i=0; i<themas.size(); i++){
            if(themas.elementAt(i).getId() == id){
                result = themas.elementAt(i);
                break;
            }
        }
        return result;
    }
}
